IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'PG_DEB_FORN_EST_NF_SAI') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_DEB_FORN] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
 CONSTRAINT [PK_PG_DEB_FORN_EST_NF_SAI] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_DEB_FORN] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_PG_DEB_FORN_EST_NF_SAI] UNIQUE NONCLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_PG_DEB_FORN_EST_NF_SAI_1] UNIQUE NONCLUSTERED 
(
	[CD_EMP] ASC,
	[CD_DEB_FORN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI] ADD  CONSTRAINT [DF_PG_DEB_FORN_EST_NF_SAI_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI] ADD  CONSTRAINT [DF_PG_DEB_FORN_EST_NF_SAI_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI] ADD  CONSTRAINT [DF_PG_DEB_FORN_EST_NF_SAI_CD_DEB_FORN]  DEFAULT ((0)) FOR [CD_DEB_FORN]

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI] ADD  CONSTRAINT [DF_PG_DEB_FORN_EST_NF_SAI_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI]  WITH CHECK ADD  CONSTRAINT [FK_PG_DEB_FORN_EST_NF_SAI_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI] CHECK CONSTRAINT [FK_PG_DEB_FORN_EST_NF_SAI_EST_NF_SAI]

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI]  WITH CHECK ADD  CONSTRAINT [FK_PG_DEB_FORN_EST_NF_SAI_PG_DEB_FORN] FOREIGN KEY([CD_EMP], [CD_DEB_FORN])
REFERENCES [dbo].[PG_DEB_FORN] ([CD_EMP], [CD_DEB_FORN])

ALTER TABLE [dbo].[PG_DEB_FORN_EST_NF_SAI] CHECK CONSTRAINT [FK_PG_DEB_FORN_EST_NF_SAI_PG_DEB_FORN]
end